﻿/*	VERSION:  1.8
1.8		Fixed the sanity-check for "thisRef" in resolveContainer()

USAGE:
	#include "functions/resolveContainer.as"
	container_ref = resolveContainer("RAM");
	
DESCRIPTION:
	Returns a reference to a global ar local container, based on its name.
	ALT
	Validates a container string and returns it if it's valid.
*/
function resolveContainer( containerName, thisRef )
{
	if(typeof(thisRef) === "string")		thisRef = _this||this;		// if: thisRef is invalid, use _this instead
	//var thisRef = (typeof(thisRef) === "string") ? _this||this : thisRef;		// use the variable, if it's a reference
	var output = _global[containerName];
	
	if(containerName == "this")
		output = thisRef;
	if(containerName == "_root")
		output = _root;
	if(containerName == "_level0")
		output = _root;
	if(containerName == "_global")
		output = _global;
	
	return output;
}// resolveContainer()



function resolveContainerStr( containerName, thisName )
{
	var thisName = (typeof(thisName) === "string") ? thisName : "this";		// use the variable, if it's a string
	var output = null;
	
	if(containerName == "this")
		output = thisName;
	if(containerName == "_root")
		output = "_root";
	if(containerName == "_level0")
		output = "_root";
	if(containerName == "_global")
		output = "_global";
	if(_global[containerName])
		output = containerName;
	
	return output;
}// resolveContainer()